$TITLE CPE2C Cobb-Douglas consumer model solution
$ONTEXT
CPE2C_sola.gms
Programmed by Hans Lofgren, IFPRI, November 1999.
Adapted by Rob Davies and Dirk van Seventer, July 2004 and March 2007
$OFFTEXT

SET

 C  commodities
    /AGR-C  agricultural commodity,
     NAGR-C  non-agricultural commodity/
    ;
 ALIAS(C,CP);

PARAMETER
 CONSVAL(C) base-year consumption values (LCU)
 /AGR-C 125, NAGR-C 150/

 INCOME base-year income or expenditure (LCU)
 ;
 INCOME = SUM(C, CONSVAL(C));

DISPLAY INCOME;

PARAMETERS
 beta(C)   share of h-hold consumption spending on commodity c
 p(C)      market price of commodity c (LCU)
 yh        household income (LCU)
 U         household utility
 ;
VARIABLE
 QH(C)     quantity of household consumption of c (base-year LCU)
 ;
EQUATION
 HHDEM(C)  consumption demand for commodity c
 ;
 HHDEM(C)..   QH(C) =E= beta(C)*yh/p(C);

MODEL
 CPE2C Cobb-Douglas consumer model
 /HHDEM/
 ;

*================================================
*CALIBRATION=====================================
*================================================

PARAMETERS

*Parameter used to define initial variable levels.
 QH0(C)    quantity of household consumption of c (base-year LCU)

*Parameter used to define base values that are changed in simulations.
 P0(C)     base market price of commodity c (LCU)

*Parameter used to define base utility
 U0        base level utility

 ;

 P0(C)  = 1;
* P0(c)=1.1;

 p(C)   = P0(C);

 yh     = INCOME;

 beta(C)  = CONSVAL(C)/SUM(CP, CONSVAL(CP));

 QH0(C) = CONSVAL(C)/p(C);

 U0    = PROD(C, QH0(C)**beta(C));

*Initializing variables
 QH.L(C)  = QH0(C);

 U    = PROD(C, QH.L(C)**beta(C));
*================================================
*SOLVING FOR BASE================================
*================================================

SOLVE CPE2C USING MCP;

DISPLAY
 P0, p, yh, beta, QH0, QH.L, U0, U;